/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.economy.transactions.composers;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.transactions.EconomyTransaction;
import net.impactdev.impactor.api.economy.transactions.composer.TransactionComposer;
import net.impactdev.impactor.api.economy.transactions.details.EconomyResultType;
import net.impactdev.impactor.api.economy.transactions.details.EconomyTransactionType;
import net.impactdev.impactor.core.economy.accounts.ImpactorAccount;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public final class BaseTransactionComposer
implements TransactionComposer {
    private Account account;
    private BigDecimal amount;
    private EconomyTransactionType type;
    private final Map<EconomyResultType, Supplier<Component>> messages = Maps.newHashMap();

    public BigDecimal amount() {
        return this.amount;
    }

    public Map<EconomyResultType, Supplier<Component>> messages() {
        return this.messages;
    }

    @Override
    public TransactionComposer account(@NotNull Account account) {
        this.account = account;
        return this;
    }

    @Override
    public TransactionComposer amount(@NotNull BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Override
    public TransactionComposer type(@NotNull EconomyTransactionType type) {
        this.type = type;
        return this;
    }

    @Override
    public TransactionComposer message(@NotNull EconomyResultType type, @NotNull @NotNull Supplier<@NotNull Component> message) {
        this.messages.put(type, message);
        return this;
    }

    @Override
    public EconomyTransaction build() {
        Preconditions.checkNotNull((Object)this.account, (Object)"account");
        Preconditions.checkNotNull((Object)((Object)this.type), (Object)"type");
        if (this.type != EconomyTransactionType.RESET) {
            Preconditions.checkNotNull((Object)this.amount, (Object)"amount");
        }
        ImpactorAccount account = (ImpactorAccount)this.account;
        return Executors.of(this.type).transact(account, this);
    }

    private static enum Executors {
        SET(EconomyTransactionType.SET, ImpactorAccount::set),
        WITHDRAW(EconomyTransactionType.WITHDRAW, ImpactorAccount::withdraw),
        DEPOSIT(EconomyTransactionType.DEPOSIT, ImpactorAccount::deposit),
        RESET(EconomyTransactionType.RESET, ImpactorAccount::reset);

        private final EconomyTransactionType type;
        private final Executor executor;

        private Executors(EconomyTransactionType type, Executor executor) {
            this.type = type;
            this.executor = executor;
        }

        public static Executors of(EconomyTransactionType type) {
            return Arrays.stream(Executors.values()).filter(executor -> executor.type == type).findFirst().orElseThrow(() -> new IllegalArgumentException("No valid executor registered"));
        }

        public EconomyTransaction transact(ImpactorAccount account, BaseTransactionComposer composer) {
            return this.executor.transact(account, composer);
        }
    }

    @FunctionalInterface
    private static interface Executor {
        public EconomyTransaction transact(ImpactorAccount var1, BaseTransactionComposer var2);
    }
}

